/*=============================================================================
 NUUN_ActorPicture_ElementSwitch_KuroCustom.js
----------------------------------------------------------------------------

/*:
 * @plugindesc 立ち絵、顔グラ表示EX くろあめ工房カスタム
 * @author くろあめ
 * @target MZ
 *
 * @param BattlePictMode1-1
 * @text 斬攻撃スイッチID（コトレッタ）
 * @desc スキルの第一攻撃属性がID1の場合、攻撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 1
 * @type switch
 *
 * @param BattlePictMode1-2
 * @text 突攻撃スイッチID（コトレッタ）
 * @desc スキルの第一攻撃属性がID2の場合、攻撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 2
 * @type switch
 *
 * @param BattlePictMode1-3
 * @text 壊攻撃スイッチID（コトレッタ）
 * @desc スキルの第一攻撃属性がID3の場合、攻撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 3
 * @type switch
 *
 * @param BattlePictMode1-4
 * @text 属性攻撃スイッチID（コトレッタ）
 * @desc スキルの第一攻撃属性がID1~3の以外場合、攻撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 4
 * @type switch
 *
 * @param BattlePictMode2-1
 * @text 斬攻撃スイッチID（フェルミ）
 * @desc スキルの第一攻撃属性がID1の場合、攻撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 5
 * @type switch
 *
 * @param BattlePictMode2-2
 * @text 突攻撃スイッチID（フェルミ）
 * @desc スキルの第一攻撃属性がID2の場合、攻撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 6
 * @type switch
 *
 * @param BattlePictMode2-3
 * @text 壊攻撃スイッチID（フェルミ）
 * @desc スキルの第一攻撃属性がID3の場合、攻撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 7
 * @type switch
 *
 * @param BattlePictMode2-4
 * @text 属性攻撃スイッチID（フェルミ）
 * @desc スキルの第一攻撃属性がID1~3の以外場合、攻撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 8
 * @type switch
 *
 * @param CounterPictMode1-1
 * @text 斬反撃スイッチID（コトレッタ）
 * @desc スキルの第一反撃属性がID1の場合、反撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 9
 * @type switch
 *
 * @param CounterPictMode1-2
 * @text 突反撃スイッチID（コトレッタ）
 * @desc スキルの第一反撃属性がID2の場合、反撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 10
 * @type switch
 *
 * @param CounterPictMode1-3
 * @text 壊反撃スイッチID（コトレッタ）
 * @desc スキルの第一反撃属性がID3の場合、反撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 11
 * @type switch
 *
 * @param CounterPictMode1-4
 * @text 属性反撃スイッチID（コトレッタ）
 * @desc スキルの第一反撃属性がID1~3の以外場合、反撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 12
 * @type switch
 *
 * @param CounterPictMode2-1
 * @text 斬反撃スイッチID（フェルミ）
 * @desc スキルの第一反撃属性がID1の場合、反撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 13
 * @type switch
 *
 * @param CounterPictMode2-2
 * @text 突反撃スイッチID（フェルミ）
 * @desc スキルの第一反撃属性がID2の場合、反撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 14
 * @type switch
 *
 * @param CounterPictMode2-3
 * @text 壊反撃スイッチID（フェルミ）
 * @desc スキルの第一反撃属性がID3の場合、反撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 15
 * @type switch
 *
 * @param CounterPictMode2-4
 * @text 属性反撃スイッチID（フェルミ）
 * @desc スキルの第一反撃属性がID1~3の以外場合、反撃立ち絵ピクチャ読み込み前にこのスイッチをONにします。
 * @default 16
 * @type switch
 *
 * @help NUUNさんの立ち絵、顔グラ表示EXプラグインにて
 * 攻撃時に、攻撃の第一属性を確認して、特定のスイッチをONにします
 * これにより、攻撃ピクチャの指定を簡略化します。
 */

(() => {

'use strict';
const script = document.currentScript;
const param = PluginManagerEx.createParameter(script);

    const _Game_Actor_performActionStart_elmSwitch = Game_Actor.prototype.performActionStart;
    Game_Actor.prototype.performActionStart = function(action) {

        var actorId = this.actorId();
        if (actorId == 1){ // コトレッタの場合
          // 攻撃の方
          var battlePictMode1 = param['BattlePictMode1-1'];
          var battlePictMode2 = param['BattlePictMode1-2'];
          var battlePictMode3 = param['BattlePictMode1-3'];
          var battlePictMode4 = param['BattlePictMode1-4'];
          // 反撃の方
          var counterPictMode1 = param['CounterPictMode1-1'];
          var counterPictMode2 = param['CounterPictMode1-2'];
          var counterPictMode3 = param['CounterPictMode1-3'];
          var counterPictMode4 = param['CounterPictMode1-4'];
        }
        else if (actorId == 2){ // フェルミの場合
          // 攻撃の方
          var battlePictMode1 = param['BattlePictMode2-1'];
          var battlePictMode2 = param['BattlePictMode2-2'];
          var battlePictMode3 = param['BattlePictMode2-3'];
          var battlePictMode4 = param['BattlePictMode2-4'];
          // 反撃の方
          var counterPictMode1 = param['CounterPictMode2-1'];
          var counterPictMode2 = param['CounterPictMode2-2'];
          var counterPictMode3 = param['CounterPictMode2-3'];
          var counterPictMode4 = param['CounterPictMode2-4'];
        }
        else{
          var battlePictMode1 = 0;
          var battlePictMode2 = 0;
          var battlePictMode3 = 0;
          var battlePictMode4 = 0;
          var counterPictMode1 = 0;
          var counterPictMode2 = 0;
          var counterPictMode3 = 0;
          var counterPictMode4 = 0;
        }
        
        // 先んじてスイッチオフ
        $gameSwitches.setValue(battlePictMode1, false);
        $gameSwitches.setValue(battlePictMode2, false);
        $gameSwitches.setValue(battlePictMode3, false);
        $gameSwitches.setValue(battlePictMode4, false);
        $gameSwitches.setValue(counterPictMode1, false);
        $gameSwitches.setValue(counterPictMode2, false);
        $gameSwitches.setValue(counterPictMode3, false);
        $gameSwitches.setValue(counterPictMode4, false);

        if (action.item().damage.elementId < 0) {
            var atkElms = this.attackElements();
            var elem = atkElms[0];
        } else {
            var elem = action.item().damage.elementId;
        }
        
        if(elem == 1){
           $gameSwitches.setValue(battlePictMode1, true);
           $gameSwitches.setValue(counterPictMode1, true);
        }else if(elem == 2){
           $gameSwitches.setValue(battlePictMode2, true);
           $gameSwitches.setValue(counterPictMode2, true);
        }else if(elem == 3){
           $gameSwitches.setValue(battlePictMode3, true);
           $gameSwitches.setValue(counterPictMode3, true);
        }else if(elem == 4 || elem == 5 || elem == 6){
           $gameSwitches.setValue(battlePictMode4, true);
           $gameSwitches.setValue(counterPictMode4, true);
        }

/* // 旧ルーチン

        if (action.item().damage.elementId < 0) {
          var elementsList = action.getAttackElementsList();
        } else {
          var elementsList = action.getItemElementsList();
        }
        
        elementsList.forEach(function(elem, index) {
            if(elem == 1){
               $gameSwitches.setValue(battlePictMode1, true);
               $gameSwitches.setValue(counterPictMode1, true);
               //console.log("switch:1 ON!");
            }else if(elem == 2){
               $gameSwitches.setValue(battlePictMode2, true);
               $gameSwitches.setValue(counterPictMode2, true);
               //console.log("switch:2 ON!");
            }else if(elem == 3){
               $gameSwitches.setValue(battlePictMode3, true);
               $gameSwitches.setValue(counterPictMode3, true);
               //console.log("switch:3 ON!");
            }else if(elem == 4 || elem == 5 || elem == 6){
               $gameSwitches.setValue(battlePictMode4, true);
               $gameSwitches.setValue(counterPictMode4, true);
            }
        });
*/
        _Game_Actor_performActionStart_elmSwitch.apply(this, arguments);

    };

    const _Game_Actor_performActionEnd_elmSwitch = Game_Actor.prototype.performActionEnd;
    Game_Actor.prototype.performActionEnd = function() {

        var actorId = this.actorId();
        if (actorId == 1){ // コトレッタの場合
          // 攻撃の方
          var battlePictMode1 = param['BattlePictMode1-1'];
          var battlePictMode2 = param['BattlePictMode1-2'];
          var battlePictMode3 = param['BattlePictMode1-3'];
          var battlePictMode4 = param['BattlePictMode1-4'];
          // 反撃の方
          var counterPictMode1 = param['CounterPictMode1-1'];
          var counterPictMode2 = param['CounterPictMode1-2'];
          var counterPictMode3 = param['CounterPictMode1-3'];
          var counterPictMode4 = param['CounterPictMode1-4'];
        }
        else if (actorId == 2){ // フェルミの場合
          // 攻撃の方
          var battlePictMode1 = param['BattlePictMode2-1'];
          var battlePictMode2 = param['BattlePictMode2-2'];
          var battlePictMode3 = param['BattlePictMode2-3'];
          var battlePictMode4 = param['BattlePictMode2-4'];
          // 反撃の方
          var counterPictMode1 = param['CounterPictMode2-1'];
          var counterPictMode2 = param['CounterPictMode2-2'];
          var counterPictMode3 = param['CounterPictMode2-3'];
          var counterPictMode4 = param['CounterPictMode2-4'];
        }
        else{
          var battlePictMode1 = 0;
          var battlePictMode2 = 0;
          var battlePictMode3 = 0;
          var battlePictMode4 = 0;
          var counterPictMode1 = 0;
          var counterPictMode2 = 0;
          var counterPictMode3 = 0;
          var counterPictMode4 = 0;
        }
        
        // 行動終了時にスイッチオフ
        $gameSwitches.setValue(battlePictMode1, false);
        $gameSwitches.setValue(battlePictMode2, false);
        $gameSwitches.setValue(battlePictMode3, false);
        $gameSwitches.setValue(battlePictMode4, false);
        $gameSwitches.setValue(counterPictMode1, false);
        $gameSwitches.setValue(counterPictMode2, false);
        $gameSwitches.setValue(counterPictMode3, false);
        $gameSwitches.setValue(counterPictMode4, false);
        
        //console.log("ALLSwitch Cleared!");

        _Game_Actor_performActionEnd_elmSwitch.apply(this, arguments);
    };
    

    // 立ち絵フラグ一括クリア 戦闘開始＆終了時に呼び出し
    Game_Party.prototype.allBattlePictModeClear = function() {
        $gameSwitches.setValue(param['BattlePictMode1-1'], false);
        $gameSwitches.setValue(param['BattlePictMode1-2'], false);
        $gameSwitches.setValue(param['BattlePictMode1-3'], false);
        $gameSwitches.setValue(param['BattlePictMode1-4'], false);
        $gameSwitches.setValue(param['CounterPictMode1-1'], false);
        $gameSwitches.setValue(param['CounterPictMode1-2'], false);
        $gameSwitches.setValue(param['CounterPictMode1-3'], false);
        $gameSwitches.setValue(param['CounterPictMode1-4'], false);
        $gameSwitches.setValue(param['BattlePictMode2-1'], false);
        $gameSwitches.setValue(param['BattlePictMode2-2'], false);
        $gameSwitches.setValue(param['BattlePictMode2-3'], false);
        $gameSwitches.setValue(param['BattlePictMode2-4'], false);
        $gameSwitches.setValue(param['CounterPictMode2-1'], false);
        $gameSwitches.setValue(param['CounterPictMode2-2'], false);
        $gameSwitches.setValue(param['CounterPictMode2-3'], false);
        $gameSwitches.setValue(param['CounterPictMode2-4'], false);
    };

})();
